<?php 
ob_start();
session_start();
include("../inc/config.php");
include("../inc/session.php");
$allPermissions = $_SESSION['permission'];

function xss_clean($data) {
    $data = trim($data);
    $data = str_replace(array('&amp;', '&lt;', '&gt;'), array('&amp;amp;', '&amp;lt;', '&amp;gt;'), $data);
    $data = preg_replace('/(&#*\w+)[\x00-\x20]+;/u', '$1;', $data);
    $data = preg_replace('/(&#x*[0-9A-F]+);*/iu', '$1;', $data);
    $data = html_entity_decode($data, ENT_COMPAT, 'UTF-8');
    $data = preg_replace('#(<[^>]+?[\x00-\x20"\'])(?:on|xmlns)[^>]*+>#iu', '$1>', $data);
    $data = preg_replace('#([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`\'"]*)[\x00-\x20]*javascript:#iu', '$1=$2nojavascript...', $data);
    $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)vbscript:#iu', '$1=$2novbscript...', $data);
    $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)-moz-binding:#u', '$1=$2nomozbinding...', $data);
    $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?expression[^>]*+>#i', '$1>', $data);
    $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?script:*[^>]*+>#iu', '$1>', $data);
    $data = preg_replace('#</*\w+:\w[^>]*+>#i', '', $data);
    do {
        $old_data = $data;
        $data = preg_replace('#</*(?:applet|base|bgsound|link|meta|object|script|style|title|xml)[^>]*+>#i', '', $data);
    } while ($old_data !== $data);
    return $data;
}

$requestData = $_REQUEST;

$columns = array(
    0 => 'id',
    1 => 'ewbNo',
    2 => 'errorDetails',
    3 => 'created_at'
);

// Count total records
$totalQuery = $pdo->query("SELECT COUNT(*) FROM api_ewb_extend_logs");
$totalData = $totalQuery->fetchColumn();
$totalFiltered = $totalData;

$sql = "SELECT id, ewbNo, errorDetails, created_at FROM api_ewb_extend_logs WHERE 1=1 ";

// Search
if (!empty($requestData['search']['value'])) {
    $search = $requestData['search']['value'];
    $sql .= " AND (ewbNo LIKE :search OR errorDetails LIKE :search)";
}

// Order
$orderColumn = $columns[$requestData['order'][0]['column']];
$orderDir = $requestData['order'][0]['dir'];
$sql .= " ORDER BY created_at DESC";

// Pagination
$sql .= " LIMIT :start, :length";

$statement = $pdo->prepare($sql);

// Bind search value
if (!empty($requestData['search']['value'])) {
    $statement->bindValue(':search', "%" . $search . "%", PDO::PARAM_STR);
}

$statement->bindValue(':start', intval($requestData['start']), PDO::PARAM_INT);
$statement->bindValue(':length', intval($requestData['length']), PDO::PARAM_INT);
$statement->execute();

$data = [];
$i = $requestData['start'] + 1;

while ($row = $statement->fetch(PDO::FETCH_ASSOC)) {
    $nestedData = array();
    $nestedData[] = $i;
    $nestedData[] = xss_clean($row['ewbNo']);
    $nestedData[] = xss_clean($row['errorDetails']);
    $nestedData[] = date('d M Y H:i:s', strtotime($row['created_at']));
    $data[] = $nestedData;
    $i++;
}

// If search applied, get filtered count
if (!empty($requestData['search']['value'])) {
    $countStmt = $pdo->prepare("SELECT COUNT(*) FROM api_ewb_extend_logs WHERE ewbNo LIKE :search OR errorDetails LIKE :search");
    $countStmt->bindValue(':search', "%" . $search . "%", PDO::PARAM_STR);
    $countStmt->execute();
    $totalFiltered = $countStmt->fetchColumn();
}

$json_data = array(
    "draw"            => intval($requestData['draw']),
    "recordsTotal"    => intval($totalData),
    "recordsFiltered" => intval($totalFiltered),
    "data"            => $data
);

echo json_encode($json_data);
?>
