<?php require_once('header.php');?>

<?php if($session_id==1 || $allPermissions['pincode']['read']==1){ ?>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<script type="text/javascript" language="javascript" >
			$(document).ready(function() {
			     var client_type = $('#client_type').val();
			     var del=<?=$allPermissions['pincode']['delete'] ?>;
                var edit=<?=$allPermissions['pincode']['update'] ?>;
				var dataTable = $('#pincode-grid').DataTable( {
					"processing": true,
					"serverSide": true,
					"ajax":{
						url :"data-tables/pincode-list-data-table.php", // json datasource
						data: {client_type:client_type,del:del,edit:edit},
						type: "post",  // method  , by default get
						error: function(){  // error handling
							$(".pincode-grid-error").html("");
							$("#pincode-grid").append('<tbody class="pincode-grid-error"><tr><th colspan="3">No data found in the server</th></tr></tbody>');
							$("#pincode-grid_processing").css("display","none");
							
						}
					}
				} );
			} );
</script>

<script>
$(document).ready(function(){
         $('#pin_search').on('click',function(){
          var pin_code_id=$('#pin_data').val();
          if(pin_code_id){
                $.ajax({
                  type:'POST',
                  url:'search_pincode_data.php',
                  data:{id:pin_code_id},
                  dataType: 'json',
                  success:function(response){
                     if(response[0]['status']==1){
                    $('#pin_status').css('color','green');
                    $('#pin_status').html('Pincode Available');
                    $("#result").show("");
                    // $('#pin_code').val(response[0]['pin_code']);
                    $('#pin_code').html(response[0]['pin_code']);
                    $('#city').html(response[0]['city']);
                    $('#state').html(response[0]['state']);
                    $('#service').html(response[0]['service']);
                    $('#air').html(response[0]['air']);
                    $('#road').html(response[0]['road']);
                    $('#b2b').html(response[0]['b2b']);
                    $('#b2c').html(response[0]['b2c']);
                    $('#oda').html(response[0]['oda']);
                    $("#edit_href").attr("href", "pincode-edit.php?id="+response[0]['id']);
                    $("#delete_href").attr("href", "pincode-delete.php?id="+response[0]['id']);
                     }
                     else
                     {
                        $('#pin_status').css('color','red');
                        $('#pin_status').html('Pincode Not Available'); 
                        $("#result").hide("");
                     }
                  }
              });
          }
      });
});
/***********    For searching the pincode number ***********/

$(document).ready(function(){
    $('#select_all').on('click',function(){
        if(this.checked){
            $('.checkbox').each(function(){
                this.checked = true;
            });
        }else{
             $('.checkbox').each(function(){
                this.checked = false;
            });
        }
      });
    
    $('.checkbox').on('click',function(){
        if($('.checkbox:checked').length == $('.checkbox').length){
            $('#select_all').prop('checked',true);
        }else{
            $('#select_all').prop('checked',false);
        }
    });
});

   function deletePincode(){
        
         var checkValues = $('input[name=checkboxlist]:checked').map(function()
            {
                return $(this).val();
            }).get();
     //   alert(checkValues);
                
  var pincode=[];
  
    pincode = checkValues; // some thing like this you can set value for 1st Param.
var len=pincode.length;
if(len>0)
{
    if(confirm('Please confirm do you want to delete...'))
    {
    window.location.href="bulk_delete_pincode.php?pincode="+pincode+"&type=1";
    }
}
else
{
    alert("Please Select Atleast one Pincode...");
}
}
</script>


<section class="content-header">
	<div class="content-header-left">
	    <h4><i class="fa fa-list"></i> View Pincode</h4>
	</div>
	 
	<div class="content-header-right">
	    <?php if($session_id==1 || $allPermissions['pincode']['create']=="1"){ ?>
		<a href="pincode-add.php" class="btn btn-danger btn-sm">Add Pincode</a>&emsp;
		<a href="pincode_bulk_upload.php" class="btn btn-danger btn-sm">Bulk Upload</a>&emsp;&emsp;
		<?php }?>
		<a href="excel/excel-all-pincode.php" class="btn btn-success btn-sm">Export as Excel</a>
        <button class="btn btn-success btn-sm" data-toggle="modal" data-target="#search-box" style="float: right;">Search Pincode</button>
	</div>
	
</section>
<input type="hidden" id="client_type" name="client_type" value="">
<section class="content">
	<div class="row">
		<div class="col-md-12">
			<div class="box box-info">
				<div class="box-body table-responsive">
					<table id="pincode-grid"  class="table table-bordered table-striped">
						<thead>
							<tr>
								<th width="30">SL</th>
								<?php if($session_id==1 || $allPermissions['pincode']['delete']=="1" || $allPermissions['pincode']['update']=="1"){ ?>	<th data-sortable= false>Action</th>	<?php }?>
								<?php if($session_id==1 || $allPermissions['pincode']['delete']=="1"){ ?>
								<th data-sortable= false><i class="fa fa-check"></i><input type="checkbox" id="select_all" /></th>
								<?php }?>
								<th>Pincode</th>
								<th>City</th>
								<th>State</th>
								<th>Location</th>
								<th>Service</th>
								<th>Air</th>
								<th>Surface</th>
								<th>B2B</th>
								<th>B2C</th>
								<th>ODA</th>
							</tr>
						</thead>
						
					</table>
				</div>
			</div>
		</div>
	</div>
	<?php if($allPermissions['pincode']['delete']=="1"){ ?>
        <div class="content-footer-right" style="margin-left:45%">
	        <button class="btn btn-danger btn-sm" onclick="deletePincode();">Delete Selected</button>&emsp;
	        <a href="#" class="btn btn-danger btn-sm" data-href="bulk_delete_pincode.php?type=2" data-toggle="modal" data-target="#confirm-delete">Delete All</a>
	    </div>
	    	<?php	}	?>							
</section>

<div class="modal fade" id="search-box" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
          <center><div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myModalLabel">Pincode Search</h4>
            </div></center>
            <div class="modal-body">
                <center><input type="text" id='pin_data' autocomplete="off" placeholder="Search Pincode" />
                <button id='pin_search' type="button" class="btn btn-danger btn-sm" name="btn">Search</button></center>
                <br><br>
                <label>Pincode Status: <span id="pin_status"></span></label>
                <div id="result" style="display:none">
                    <table class="table table-bordered table-striped .table-hover" >
						<thead class="thead-light">
							<tr>
							    <th>Pincode :</th>
								<th>City :</th>
								<th>State :</th>
							</tr>
						</thead>
						<tbody>
						    <tr>
    						    <td><span id="pin_code"></span></td>
    						    <td><span id="city"></span></td>
    						    <td><span id="state"></span></td>
						    </tr>
						</tbody>
						<thead>
							<tr>
							    <th>Service :</th>
								<th>Air :</th>
								<th>Road :</th>
							</tr>
						</thead>
						<tbody>
						    <tr>
    						    <td><span id="service"></span></td>
    						    <td><span id="air"></span></td>
    						    <td><span id="road"></span></td>
						    </tr>
						</tbody>
						<thead>
							<tr>
							    <th>B2B :</th>
								<th>B2C :</th>
								<th>ODA :</th>
							</tr>
						</thead>
						<tbody>
						    <tr>
    						    <td><span id="b2b"></span></td>
    						    <td><span id="b2c"></span></td>
    						    <td><span id="oda"></span></td>
						  </tr>
					</tbody>
					</table>
				<center><?php if($allPermissions['pincode']['update']=="1"){ ?><a href="" id='edit_href' class="btn btn-danger btn-xs">Edit</a><?php }?>&emsp;&emsp;
				<?php if($allPermissions['pincode']['delete']=="1"){ ?><a href="" id='delete_href' class="btn btn-danger btn-xs">Delete</a></center><?php }?>
                </div>
            </div>
            <div class="modal-footer">
                
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myModalLabel">Delete Confirmation</h4>
            </div>
            <div class="modal-body">
                <p>Are you sure want to delete all pincodes?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a class="btn btn-danger btn-ok">Delete</a>
            </div>
        </div>
    </div>
</div>

<style type="text/css">
    body{
        font-family: Arail, sans-serif;
    }
    /* Formatting search box */
    .search-box{
        width: 300px;
        position: relative;
        display: inline-block;
        font-size: 14px;
    }
    .search-box input[type="text"]{
        height: 32px;
        padding: 5px 10px;
        border: 1px solid #CCCCCC;
        font-size: 14px;
    }
    .result{
        position: absolute;        
        z-index: 999;
        top: 100%;
        left: 0;
    }
    .search-box input[type="text"], .result{
        width: 100%;
        box-sizing: border-box;
    }
    /* Formatting result items */
    .result p{
        margin: 0;
        padding: 7px 10px;
        border: 1px solid #CCCCCC;
        border-top: none;
        cursor: pointer;
    }
    .result p:hover{
        background: #f2f2f2;
    }
</style>

<?php }else{ ?>
<center><h4 style="color:red;">You don't have permission to view pincode </h4></center>
<?php } ?>
<?php require_once('footer.php'); ?>