<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Shipment Tracking</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://unpkg.com/framer-motion/dist/framer-motion.umd.js"></script>
  <style>
    body {
  background-image: url('https://images.unsplash.com/photo-1552083375-1447ce886485?auto=format&fit=crop&w=1920&q=80');
  background-size: cover;
  background-position: center;
  background-repeat: no-repeat;
}

    .glass {
      backdrop-filter: blur(10px);
      background-color: rgba(255, 255, 255, 0.2);
      border: 1px solid rgba(255, 255, 255, 0.3);
    }
  </style>
</head>
<body class="min-h-screen flex items-center justify-center px-4 py-10">

  <!-- Main Container -->
  <div id="formContainer" class="glass max-w-2xl w-full rounded-3xl p-8 shadow-2xl text-white">

    <!-- Header -->
    <div class="text-center mb-8">
      <h2 class="text-4xl font-bold">View Shipment Tracking</h2>
      <p class="text-lg mt-2 text-blue-100">Enter your AWB number to track your shipment</p>
    </div>

    <!-- Form -->
    <form action="https://venus-cargo.fms-logistics.in.net/admin-new/ui-shipment-tracking.php" method="POST" class="space-y-6">
      <!-- Hidden Tracking Type -->
      <div hidden>
        <label for="type" class="block text-sm font-medium">Tracking Type</label>
        <select id="type" name="type" class="w-full border border-gray-300 rounded-lg px-4 py-2">
          <option value="cscs_awb">AWB</option>
        </select>
      </div>

      <!-- AWB Input -->
      <div>
        <label for="track_id" class="block text-sm font-semibold mb-1">AWB Number</label>
        <input type="text" name="track_id" id="track_id" required
          class="w-full rounded-lg px-4 py-3 text-gray-800 focus:ring-4 focus:ring-blue-400 outline-none" placeholder="Enter AWB Number">
      </div>

      <!-- Submit Button -->
      <div class="text-center">
        <button type="submit"
          class="bg-blue-600 hover:bg-blue-700 transition-all duration-300 text-white px-8 py-3 rounded-lg font-semibold shadow-lg">
          Search
        </button>
      </div>
    </form>
  </div>

  <!-- Framer Motion Animation -->
  <script>
    const motion = window.framerMotion;
    const { animate } = motion;

    // Animate container on load
    const formContainer = document.getElementById("formContainer");
    animate(formContainer, { opacity: [0, 1], scale: [0.9, 1] }, { duration: 0.8, delay: 0.2 });

    // Button hover animation
    const button = document.querySelector("button");
    button.addEventListener("mouseover", () => {
      animate(button, { scale: 1.05 }, { duration: 0.2 });
    });
    button.addEventListener("mouseout", () => {
      animate(button, { scale: 1 }, { duration: 0.2 });
    });
  </script>

</body>
</html>
