<?php

ob_start();
session_start();
include "inc/config.php";
include "inc/session.php";
include "inc/functions.php";
include "inc/CSRF_Protect.php";
$csrf = new CSRF_Protect();
$error_message='';

if(isset($session)) {
	header('location: index.php');
	exit;
}


if(isset($_POST['login'])) {
        
    if(empty($_POST['email']) || empty($_POST['password'])) {
        $error_message = 'Username or Password can not be empty';
    } else {
		
		$username = strip_tags($_POST['email']);
		$password = strip_tags($_POST['password']);
		

    	$statement = $pdo->prepare("SELECT u.*, r.permission
    	FROM tbl_users u
    	INNER JOIN tbl_role r ON u.role_id=r.id 
    	WHERE u.email=? AND u.password=? and u.status=1");
    	$statement->execute(array($username,$password));
        $result = $statement->fetchAll(PDO::FETCH_ASSOC);  
        $total = $statement->rowCount(); 
        if($total==0) {
            $error_message = 'Username does not match';
        }else {   
                $_SESSION["$session_name"] = $result[0];
                $_SESSION["$session_name"]['type'] = $result[0]['user_type_id'];
                $_SESSION['permission'] = json_decode($result[0]['permission'], true);
                header("location: index.php");
                
                error_log("login: ".$session_name);
        }
    }
}



$statement = $pdo->prepare("SELECT * FROM tbl_settings WHERE id=1");   
$statement->execute();
$query = $statement->fetchAll(PDO::FETCH_ASSOC);
$totalData = $statement->rowCount();
if($totalData>0){
    $site_name = $query[0]['name'];
    $logo = $query[0]['logo'];
    $favicon = $query[0]['favicon'];
    $short_name = $query[0]['short_name'];
}
?>




<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>Login | <?=$site_name?></title>

	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/datepicker3.css">
	<link rel="stylesheet" href="css/all.css">
	<link rel="stylesheet" href="css/select2.min.css">
	<link rel="stylesheet" href="css/dataTables.bootstrap.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/_all-skins.min.css">
    <link rel="stylesheet" href="style.css">
</head>


<!--<style>-->
<!--    body {-->
<!--  background-image: url('img/bg1.png');-->
<!--}-->
<!--</style>-->
<style>
    .login-box-body, .register-box-body {
    background: #e6e6e6bd;
    padding: 20px;
    border-top: 0;
    border-radius: 20px;
    color: #666;
}
</style>



<body class="hold-transition login-page sidebar-mini" style="background-image: url('https://www.logipulse.com/static/dff636fc5f303a4a6a6e2bc1f9236a8d/3464f/Blog-Image-i.jpg');background-repeat: no-repeat;  background-size: cover;">

<div class="login-box">
	<div class="login-logo">
		<b style="color:white;">Admin Panel</b>
	</div>
  	<div class="login-box-body">
  	    <center><img src="<?=$logo?>" alt="logo" style="width:100px;"></center>
    	<p class="login-box-msg" style="color:black;">Log in to start your session</p>
    
	   
		<form action="" method="post">
			<?php $csrf->echoInputField(); ?>
			<div class="form-group has-feedback">
				<input class="form-control" placeholder="Email Address" name="email" type="text" autocomplete="off" autofocus>
			</div>
			<div class="form-group has-feedback">
				<input class="form-control" placeholder="Password" name="password" type="password" autocomplete="off">
			</div>
			 <?php 
	    if( (isset($error_message)) && ($error_message!='') ):
	        echo '<div class="error" style="color:red;">'.$error_message.'</div>';
	    endif;
	    ?>

			
			<!--<div class="form-group has-feedback">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			<input type="radio" id="male" name="type" value="admin" checked>
            <label for="male">Admin</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <input type="radio" id="female" name="type" value="client">
            <label for="female">Client</label>
            </div>-->
			
			
			<div class="row">
				<div class="col-xs-8"></div>
				<div class="col-xs-4">
					<input type="submit" class="btn btn-danger btn-block btn-flat login-button" name="login" value="Log In">
				</div>
			</div>
			
			
		</form>
		
	</div>
</div>


<script src="js/jquery-2.2.3.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/jquery.dataTables.min.js"></script>
<script src="js/dataTables.bootstrap.min.js"></script>
<script src="js/select2.full.min.js"></script>
<script src="js/jquery.inputmask.js"></script>
<script src="js/jquery.inputmask.date.extensions.js"></script>
<script src="js/jquery.inputmask.extensions.js"></script>
<script src="js/moment.min.js"></script>
<script src="js/bootstrap-datepicker.js"></script>
<script src="js/icheck.min.js"></script>
<script src="js/fastclick.js"></script>
<script src="js/jquery.sparkline.min.js"></script>
<script src="js/jquery.slimscroll.min.js"></script>
<script src="js/app.min.js"></script>
<script src="js/demo.js"></script>

</body>
</html>